TITLE 									{ exa081.pde }
   'Conduction in a Rectangular Plate'
SELECT							{ Student Edition }
   errlim=1e-5     spectral_colors
VARIABLES
   U
DEFINITIONS
   Lx=0.5     Ly=1.0     cond=5.99e7                	{ Conductivity of Cu }
   Ex=-dx(U)     Ey=-dy(U)     E=-grad(U)     Em=magnitude(E)
   Jx=cond*Ex     Jy=cond*Ey     J=cond*E     Jm=magnitude(J)
   U_ex=y/Ly*1.0						{ Exact solution for 1.0 V }
EQUATIONS
   div( J)=0							{ 2nd order PDE in U }
BOUNDARIES
region 'domain'
   start(-Lx,0)  value(U)=0  line to (Lx,0)
   natural(U)=0 line to (Lx,Ly)      			{ Insulated, Ex=Jx=0 }
   value(U)=1.0 line to (-Lx,Ly)
   natural(U)=0 line to close       			{ Insulated }
PLOTS
   contour( U)     surface( U)     vector( E)
   contour( Jx)     contour( Jy)     contour( Jm)     contour( U-U_ex)
END


